<?php
if (!defined('PAYMENT')) {
    http_response_code(404);
    die();
}
$transactionId = $_REQUEST['transactionId'] ?? null;
$paymentMethod = $_REQUEST['paymentMethod'] ?? null;
$paymentAmount = $_REQUEST['paymentAmount'] ?? null;
$paymentMethod = ucfirst(strtolower($paymentMethod));

if (!empty($paymentAmount)) {
    $paymentAmount = ceil((float)$paymentAmount);
}

if (empty($transactionId)) {
    $jsonInput = file_get_contents('php://input');
    if ($jsonInput) {
        $decodedInput = json_decode($jsonInput, true);
        $transactionId = $decodedInput['transaction_id'] ?? null;
    }
}

if (empty($transactionId)) {
    error_log("codekureghor Callback: Transaction ID not received.");
    errorExit("Transaction ID is missing.");
}

$apiKey = trim($methodExtras['api_key']);
$apiUrl = "https://pay.codekureghor.com/api/payment/verify";
$postData = ['transaction_id' => $transactionId];

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $apiUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode($postData),
    CURLOPT_HTTPHEADER => [
        "API-KEY: " . $apiKey,
        "Content-Type: application/json",
        "Accept: application/json"
    ],
]);

$response = curl_exec($curl);
$error = curl_error($curl);
curl_close($curl);

if ($error) {
    error_log("codekureghor cURL Error for TXN ID {$transactionId}: " . $error);
    errorExit("cURL Error: " . $error);
}

if (empty($response)) {
    error_log("codekureghor Error for TXN ID {$transactionId}: Empty response from payment API.");
    errorExit("Empty response from payment API.");
}

$data = json_decode($response, true);

if (
    !is_array($data) || 
    empty($data['status']) || 
    empty($data['metadata']) || 
    $data['status'] !== 'COMPLETED'
) {
    error_log("codekureghor Error for TXN ID {$transactionId}: Invalid API response -> " . $response);
    errorExit("Invalid or Incomplete response from payment API.");
}


$metadata = is_array($data['metadata']) ? $data['metadata'] : json_decode($data['metadata'], true);

if (empty($metadata['order_id'])) {
    error_log("codekureghor Error for TXN ID {$transactionId}: order_id not found in metadata.");
    errorExit("Order ID not found in API response metadata.");
}

$orderId = $metadata['order_id'];
$paymentStmt = $conn->prepare("SELECT * FROM payments WHERE payment_extra = :orderId AND payment_status = 1");
$paymentStmt->execute(['orderId' => $orderId]);

if ($paymentStmt->rowCount() == 0) {
    error_log("codekureghor Error for TXN ID {$transactionId}: Order ID {$orderId} not found in DB or not in pending state.");
    errorExit("Order ID not found or already processed.");
}

$payment = $paymentStmt->fetch(PDO::FETCH_ASSOC);
$user = $conn->prepare("SELECT * FROM clients WHERE client_id = :id");
$user->execute(['id' => $payment['client_id']]);
$user = $user->fetch(PDO::FETCH_ASSOC);

$_SESSION["msmbilisim_userlogin"] = 1;
$_SESSION["msmbilisim_userid"] = $user["client_id"];
$_SESSION["msmbilisim_userpass"] = $user["password"];

$paidAmount = floatval($payment["payment_amount"]);
$finalAmount = $paidAmount;

if ($paymentFee > 0) {
    $fee = ($finalAmount * ($paymentFee / 100));
    $finalAmount -= $fee;
}

if ($paymentBonusStartAmount > 0 && $finalAmount > $paymentBonusStartAmount) {
    $bonus = $finalAmount * ($paymentBonus / 100);
    $finalAmount += $bonus;
}

$finalAmount = round($finalAmount, 2);
$newBalance = $user['balance'] + $finalAmount;

$updatePayment = $conn->prepare("UPDATE payments SET 
    payment_status = 3, 
    payment_delivery = 2,
    client_balance = :user_balance
    WHERE payment_id = :id
");
$updatePayment->execute([
    'user_balance' => $user['balance'],
    'id' => $payment['payment_id']
]);

if ($updatePayment->rowCount()) {
    $updateBalance = $conn->prepare("UPDATE clients SET balance = :new_balance WHERE client_id = :id");
    $updateBalance->execute([
        'new_balance' => $newBalance,
        'id' => $user['client_id']
    ]);

} else {
    error_log("codekureghor Error for TXN ID {$transactionId}: Failed to update payments table for Order ID {$orderId}.");
    errorExit("Failed to update payment status.");
}

header("Location: " . site_url("addfunds"));
exit();